/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.designer;

import filenet.vw.apps.designer.images.VWImageLoader;
import filenet.vw.apps.designer.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class VWSaveOptionDialog
extends VWModalDialog
implements ActionListener {
    public static final int CHOICE_SAVE = 2;
    public static final int CHOICE_CANCEL = 4;
    public static final int DOC_TYPE_WORKFLOW = 0;
    public static final int DOC_TYPE_STEPPALETTE = 1;
    public static final int DOC_TYPE_CONFIGURATION = 2;
    private JRadioButton m_saveRadioButton = null;
    private JRadioButton m_cancelRadioButton = null;
    private ButtonGroup m_radioGroup = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private boolean m_bCanCancel = true;
    protected String m_option2 = null;
    protected int m_nChoice = 2;
    protected int m_nStatus = 1;
    protected int m_nDocType = 0;

    public VWSaveOptionDialog(Frame parentFrame, String title, int nDocType, String option2, boolean bCanCancel) {
        super(parentFrame);
        this.setTitle(title);
        this.m_nDocType = nDocType;
        this.m_option2 = option2;
        this.m_bCanCancel = bCanCancel;
        this.initLayout();
    }

    public VWSaveOptionDialog(Frame parent, String title, String option2, boolean bCanCancel) {
        this(parent, title, 0, option2, bCanCancel);
    }

    public VWSaveOptionDialog(Frame parent, String title, String option2) {
        this(parent, title, 0, option2, true);
    }

    public int getStatus() {
        return this.m_nStatus;
    }

    public int getChoice() {
        return this.m_nChoice;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this.m_saveRadioButton) {
                this.performSave();
            } else if (source == this.m_cancelRadioButton) {
                this.performCancelCheckout();
            } else if (source == this.m_okButton) {
                this.performOK();
            } else if (source == this.m_cancelButton) {
                this.performCancel();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void initLayout() {
        try {
            this.getContentPane().setLayout(new BorderLayout(5, 5));
            this.getContentPane().add((Component)this.getMainPanel(), "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel getMainPanel() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = -1;
            gbCons.gridheight = 2;
            gbCons.insets = new Insets(5, 5, 2, 10);
            ImageIcon questionIcon = VWImageLoader.createImageIcon("question.gif");
            mainPanel.add((Component)new JLabel(questionIcon), gbCons);
            ++gbCons.gridx;
            ++gbCons.gridy;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.gridwidth = 0;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(5, 0, 2, 0);
            switch (this.m_nDocType) {
                case 0: {
                    mainPanel.add((Component)new JLabel(VWIDMBaseFactory.instance().getVWString(26).toString()), gbCons);
                    break;
                }
                case 1: {
                    mainPanel.add((Component)new JLabel(VWIDMBaseFactory.instance().getVWString(28).toString()), gbCons);
                    break;
                }
                case 2: {
                    mainPanel.add((Component)new JLabel(VWIDMBaseFactory.instance().getVWString(29).toString()), gbCons);
                }
            }
            ++gbCons.gridy;
            gbCons.insets = new Insets(0, 0, 2, 0);
            mainPanel.add((Component)new JLabel(VWResource.s_doYouWantTo), gbCons);
            ++gbCons.gridy;
            this.m_saveRadioButton = new JRadioButton(VWResource.s_checkItIn);
            this.m_saveRadioButton.setSelected(true);
            this.m_saveRadioButton.addActionListener(this);
            mainPanel.add((Component)this.m_saveRadioButton, gbCons);
            ++gbCons.gridy;
            this.m_cancelRadioButton = new JRadioButton(this.m_option2);
            this.m_cancelRadioButton.setSelected(false);
            this.m_cancelRadioButton.addActionListener(this);
            mainPanel.add((Component)this.m_cancelRadioButton, gbCons);
            this.m_radioGroup = new ButtonGroup();
            this.m_radioGroup.add(this.m_saveRadioButton);
            this.m_radioGroup.add(this.m_cancelRadioButton);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel getButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new FlowLayout(1, 5, 5));
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.addActionListener(this);
            buttonPanel.add(this.m_okButton);
            if (this.m_bCanCancel) {
                this.m_cancelButton = new JButton(VWResource.s_cancel);
                this.m_cancelButton.addActionListener(this);
                buttonPanel.add(this.m_cancelButton);
            }
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void performSave() {
        this.m_nChoice = 2;
    }

    protected void performCancelCheckout() {
        this.m_nChoice = 4;
    }

    protected void performOK() {
        this.m_nStatus = 0;
        this.setVisible(false);
    }

    protected void performCancel() {
        this.m_nStatus = 1;
        this.setVisible(false);
    }
}

